package lac.contextnet.sddl_longrunningtest;


import android.content.Intent;
import android.support.v4.app.Fragment;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.infopae.model.SDDLLocation;

import java.util.ArrayList;

import co.aenterhy.toggleswitch.ToggleSwitchButton;
import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneAdapter;
import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneModel;
import lac.contextnet.sddl_longrunningtest.service.ConnectionListener;
import lac.contextnet.sddl_longrunningtest.service.ConnectionService;

/**
 * A simple {@link Fragment} subclass.
 */
public class MapsFragment extends Fragment implements View.OnClickListener,OnMapReadyCallback {

    static final LatLng HAMBURG = new LatLng(53.558, 9.927);
    static final LatLng KIEL = new LatLng(53.551, 9.993);
    private GoogleMap map;
    private SmartphoneAdapter adapter;

    private ToggleSwitchButton toggle;

    public static Fragment newInstance(String text) {
        MapsFragment fragment = new MapsFragment();
        return fragment;
    }

    public MapsFragment() {
        // Required empty public constructor
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_map, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        adapter = MainActivity.adapter;

        toggle = (ToggleSwitchButton) view.findViewById(R.id.toggle);
        toggle.setOnTriggerListener(new ToggleSwitchButton.OnTriggerListener() {
            @Override
            public void toggledUp() {
                ArrayList<SDDLLocation> temp = ConnectionListener.receiveList;

                if(temp != null && temp.size()>0) {
                    LatLng latLng;
                    for (SDDLLocation loc : ConnectionListener.receiveList) {
                        latLng = new LatLng(loc.getLatitude(), loc.getLongitude());
                        String uuid = AppConfig.getUuid(getContext()).toString();
                        if(!uuid.equalsIgnoreCase(loc.getUuid()))
                            map.addMarker(new MarkerOptions().position(latLng).title(loc.getUuid()));
                        else
                            map.addMarker(new MarkerOptions().position(latLng).title("- Sou eu! -").icon(BitmapDescriptorFactory
                                    .defaultMarker(BitmapDescriptorFactory.HUE_AZURE)));
                    }
                    latLng = new LatLng(-22.9473284, -43.22278976);
                    map.moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 12));
                }
            }

            @Override
            public void toggledDown() {

            }
        });

        SupportMapFragment mapFragment = (SupportMapFragment) getChildFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync(this);
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }


    @Override
    public void onClick(View view) {
    }

    /* check if there is an IP and Port on the config file */
    private Boolean hasIpAndPort () {
        String ip = AppConfig.getIpPort(getContext());
        if (AppConfig.isValidIpPort(ip))
            return true;
        return false;
    }

    @Override
    public void onMapReady(GoogleMap map) {
        this.map = map;
        ArrayList<SDDLLocation> temp = ConnectionListener.receiveList;

        if(temp != null && temp.size()>0) {
            LatLng latLng = new LatLng(-22.92, -43.25);
            for (SDDLLocation loc : ConnectionListener.receiveList) {
                String uuid = AppConfig.getUuid(getContext()).toString();
                latLng = new LatLng(loc.getLatitude(), loc.getLongitude());
                if(!uuid.equalsIgnoreCase(loc.getUuid()))
                    map.addMarker(new MarkerOptions().position(latLng).title(loc.getUuid()));
                else
                    map.addMarker(new MarkerOptions().position(latLng).title(loc.getUuid() + "- Sou eu! -").icon(BitmapDescriptorFactory
                            .defaultMarker(BitmapDescriptorFactory.HUE_AZURE)));
                map.moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 10));
            }
            //map.moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 10));
            map.animateCamera(CameraUpdateFactory.zoomTo(1), 2000, null);
        }
    }

}
